#!/bin/bash

if [ "$1" == "" ]; then
	echo "Specify a name!"
	exit
fi

configFile=levels/$1.config.xml
objectsFile=levels/$1.objects.xml
resourcesFile=levels/$1.resources.xml
templateFile=levels/$1.templates.xml

if [ -f $configFile ]; then
	echo "Template File '$configFile' already exists"
	exit
fi

if [ -f $objectsFile ]; then
	echo "Objects File '$objectsFile' already exists"
	exit
fi

if [ -f $resourcesFile ]; then
	echo "Resources File '$resourcesFile' already exists"
	exit
fi

if [ -f $templateFile ]; then
	echo "Template File '$templateFile' already exists"
	exit
fi

cp levels/empty/emptySinglePlayer.objects.xml levels/$1.objects.xml
cp levels/empty/emptySinglePlayer.resources.xml levels/$1.resources.xml
cp levels/empty/emptySinglePlayer.config.xml levels/$1.config.xml

svn add levels/$1.*.xml
